<?php

/**
* Tests that WACT templates are case insensative, but case preserving.
*/
class CaseSensitivity_TestCase extends Wact_Test_Case_Template {

    function testAttributeCasePreserved() {
        $template = '<tag one="one" Two="Two" THREE="THREE">contents</tag>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactAttributeCasePreserved() {
        $template = '<div wact:id="test" one="one" Two="Two" THREE="THREE">contents</div>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div one="one" Two="Two" THREE="THREE">contents</div>');
    }

    function testTagCasePreserved() {
        $template = '<BR /><br /><Br />';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTagCasePreserved() {
        $template = '<DIV wact:id="test1"></DIV><Div wact:id="test2"></Div><div wact:id="test3"></div>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV></DIV><Div></Div><div></div>');
    }

}
?>