<?php

/**
* Create mocks
*/
Mock::generate('Wact_Template_Compiler_Parser_State_Literal','MockLiteralParsingState');
Mock::generate('Wact_Template_Compiler_Parser_State_Component','MockComponentParsingState');
Mock::generate('Wact_Html_Sax_Locator','MockSaxLocator');
Mock::generatePartial('Wact_Template_Compiler_Parser_Source','SourceParserTestVersion',array('Wact_Template_Compiler_Parser_Source'));

class Wact_Template_Compiler_Parser_SourceTestCase extends Wact_Test_Case {

    var $parser;

    function setUp() {
        $this->parser = new SourceParserTestVersion($this);
        $this->parser->componentParsingState = new MockComponentParsingState($this);
        $this->parser->literalParsingState = new MockLiteralParsingState($this);
        $this->parser->state = $this->parser->componentParsingState;
    }

    function tearDown() {
        unset($this->parser);
    }

    /*
    function testBuildFilterChain() {
        $parser = $this->parser->buildFilterChain('tagstolower');
        $this->parser->componentParsingState->expectOnce('startElement', array('test', '*'));
        $parser->startElement('TEST', array());
    }
    */

    function testChangeToComponentParsingState() {
        $this->parser->changeToComponentParsingState();
        $this->assertIsA($this->parser->state, 'MockComponentParsingState');
    }

    function testChangeToLiteralParsingState() {
        $this->parser->changeToLiteralParsingState('test');
        $this->assertIsA($this->parser->state, 'MockLiteralParsingState');
        // $this->assertEqual($this->parser->literalParsingState->literalTag, 'test');
    }

    function testSetDocumentLocator() {
        $this->parser->componentParsingState->expectOnce('setDocumentLocator');
        $this->parser->literalParsingState->expectOnce('setDocumentLocator');
        $locator = new MockSaxLocator($this);

        $this->parser->startDocument($locator, 'UTF-8');

        $this->parser->componentParsingState->tally();
        $this->parser->literalParsingState->tally();
    }

    function testStartElement() {
        $tag = 'test';
        $attributes = array('foo' => 'bar');
        $this->parser->state->expectOnce('startElement', array($tag, $attributes));
        $this->parser->startElement($tag, $attributes);
        $this->parser->state->tally();
    }

    function testEndElement() {
        $tag = 'test';
        $this->parser->state->expectOnce('endElement', array($tag));
        $this->parser->endElement($tag);
        $this->parser->state->tally();
    }

    function testEmptyElement() {
        $tag = 'test';
        $attributes = array('foo' => 'bar');
        $this->parser->state->expectOnce('emptyElement', array($tag, $attributes));
        $this->parser->emptyElement($tag, $attributes);
        $this->parser->state->tally();
    }

    function testCharacters() {
        $data = 'test';
        $this->parser->state->expectOnce('characters', array($data));
        $this->parser->characters($data);
        $this->parser->state->tally();
    }

    function testComment() {
        $text = 'test';
        $this->parser->state->expectOnce('comment', array($text));
        $this->parser->comment($text);
        $this->parser->state->tally();
    }

}
?>