<?php

/**
* Make partial mock to control behaviour of getViewId which has static counter
*/
Mock::generate('Wact_Template_Compiler_Node', 'MockTemplateNode');
Mock::generatePartial('Wact_Template_Compiler_Node_TagView','Wact_Template_Compiler_Node_TagViewTestVersion',
    array('getViewId'));
Mock::generate('Wact_Template_Compiler_Node_TagView','MockTagViewTemplateNode');

class Wact_Template_Compiler_Node_TagViewTestCase extends Wact_Test_Case {

    function setUp() {
        $this->node = new Wact_Template_Compiler_Node_TagViewTestVersion($this);
        $this->node->__construct(
            'test', 
            new Wact_Template_Compiler_Generic_Info('test'),
            new Wact_Template_Compiler_Location('file', 123));
        $this->node->setClosing(Wact_Template_Compiler_Node::CLOSING_TAG);
        $this->node->setReturnValue('getViewId','id001');
    }

    function tearDown() {
        unset ( $this->node );
        parent::tearDown();
    }

    function testGetRenderedTag() {
        $this->assertEqual($this->node->getRenderedTag(), 'test');
    }

    function testGetAttributesAsArray() {
        $this->node->setAttributeValue('foo', 'bar');
        $this->node->setAttributeValue('tricky', NULL);
        $this->assertIdentical(
            $this->node->getAttributesAsArray(array('tricky')),
            array('foo'  => 'bar'));
    }
    
    /*
    function testGenerateExtraAttributes() {
        // BAD TEST: see bug #896626
        // HF - small improvement but violating CodeWriter API plus not using a mock
        $mockAttr = new AttributeVariableReferenceTestVersion($this);
        $mockAttr->setReturnValue('isConstant',FALSE);
        $mockAttr->setReturnValue('getComponentRefCode','$DataSpace');      
        $mockAttr->name = 'foo';
        $mockAttr->reference = 'bar';
        $mockAttr->scope = '$';
        $mockAttr->Context = new MockTagViewTemplateNode($this);
        $mockAttr->Context->setReturnValue('getDataSourceRefCode','$Foo');
        $this->node->addChildAttribute($mockAttr);
        $code = new WactOldCodeWriter();
        $this->node->generateExtraAttributes($code);
        $this->assertEqual($code->code,' foo="<?php echo htmlspecialchars($foo->get(\'bar\'), ENT_QUOTES); ?>"');
    }
    */

/*  
    function testPreGenerate() {
        // BAD TEST: see bug #896626
        // HF - small improvement but violating CodeWriter API plus not using a mock
        $code = new WactOldCodeWriter();
        $this->node->preGenerate($code);
        $this->assertEqual($code->getCode(), '<?php $this->children[\'id001\']->paintOpen(); ?>');
    }
*/
/*
    function testPostGenerate() {
        // BAD TEST: see bug #896626
        // HF - small improvement but violating CodeWriter API plus not using a mock
        $code = new WactOldCodeWriter();
        $this->node->postGenerate($code);
        $this->assertEqual($code->getCode(), '<?php $this->children[\'id001\']->paintClose(); ?>');
    }
*/
    /**
    * @todo This test could be improved to examine the written code. Currently only checks call count
    */
/*
    function testGenerateConstructor() {
        // BAD TEST: see bug #896626
        // HF - small improvement but violating CodeWriter API plus not using a mock
        $this->node->parentViewClass = 'testcomponent';
        $code = new WactOldCodeWriter();
        $this->node->generateConstructor($code);
        $this->assertEqual($code->getCode(), '<?php require_once \'testinclude.inc.php\';' . "\n" .
          '?><?php $this->addChild(new testcomponent(\'test\'), \'id001\');$this->children[\'id001\']->attributes = unserialize(\'a:0:{}\'); ?>');
    }
*/

}
?>
