<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* An inline template node contains a fragment of code that will be generated into the
* Final template.  These nodes do not have corresponding Views, but rather merge their
* capabilities into the code of their parent.
*/
class Wact_Template_Compiler_Node_Inline extends Wact_Template_Compiler_Node {

    function addChildAttribute($child) {
        if ($child->name == Wact_Template_Compiler_Attribute::WACT_ID) {
            throw new Wact_Template_Compiler_Exception(
                'Invalid attribute "{Attribute}" for tag "{Tag}" in template file "{Filename}" on line {Lineno}',
                $child->name,
                $this->tag,
                $this->sourceLocation->file,
                $this->sourceLocation->line
            );
        }
        parent::addChildAttribute($child);
    }

    /**
    * Does this component desire to generate code into its parent's paint method?
    */
    function isInlinePaintRequired() {
        return TRUE;
    }

    /**
    * Pre generation method
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePrePaint($code) {
    }

    /**
    * Post generation method
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePostPaint($code) {
    }
    
    /**
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePaintInline($code) {
        $this->generatePrePaint($code);
        $this->generateChildPaintInline($code);
        $this->generatePostPaint($code);
    }

    /**
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePaintMethod($code) {
        // Inline views do not have paint methods and render into their parent's method
        throw new Wact_Template_Compiler_Exception(
            'Cannot generate paint method for tag "{Tag}" in template file "{Filename}" on line {Lineno}',
            $this->tag,
            $this->sourceLocation->file,
            $this->sourceLocation->line
        );
    }

}

?>