<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Renders the tree
*/
class Wact_Template_Compiler_Node_Debug {

    protected $node;

    function __construct($node) {
        $this->node = $node;
    }

    function printNode($node) {
        echo '<div>';
        $name = $node->getViewId();
        if (empty($name)) {
            $name = '(top level)';
        }
        
        echo '<b>' . $name .  '</b> :: ';
        echo get_class($node);
        echo '<br />';
        /*
        if (is_a($node, 'Wact_Template_Compiler_Node_Text')) {
            echo 'contents:';
            var_dump($node->getContents());
            echo '<br />';
        }
        */
        if (count($node->children) > 0) {
            echo '<ul>';
            foreach ($node->children as $child) {
                echo '<li>';
                $this->printNode($child);
                echo '</li>';
            }
            echo '</ul>';
        }
        echo '<div>';
    }

    function dump() {
        // $this->printPageHeader();
        $this->printNode($this->node);
        // $this->printPageFooter();
    }
    
}
?>