<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Template_Compiler_Formatter extends Wact_Template_Compiler_Expression_Node {

    /**
    */
    protected $parameters = array();

    /**
    */
    function registerParameter($parameter) {
        $this->parameters[] = $parameter;
    }

    /**
    * Does this formatter refer to a constant value at compile time?
    * @return Boolean
    */
    function isConstant() {
        $isConstant = TRUE;
        foreach( $this->parameters as $parameter) {
            $isConstant = $isConstant && $parameter->isConstant();
        }
        return $isConstant;
    }

    /**
    * Generate setup code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePreStatement($code) {
        foreach( $this->parameters as $parameter) {
            $parameter->generatePreStatement($code);;
        }
    }

    /**
    * Generate tear down code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePostStatement($code) {
        foreach($this->parameters as $parameter) {
            $parameter->generatePostStatement($code);;
        }
    }

    /**
    */
    function prepare() {
        foreach($this->parameters as $parameter) {
            $parameter->prepare();
        }
    }

}

?>