<?php

class Wact_Template_Compiler_Expression_Node_AndTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $t = new Wact_Template_Compiler_Expression_Node_Constant(TRUE);
        $f = new Wact_Template_Compiler_Expression_Node_Constant(FALSE);
        $node = new Wact_Template_Compiler_Expression_Node_And($t, $f);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), FALSE);
    }

}

class Wact_Template_Compiler_Expression_Node_OrTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $t = new Wact_Template_Compiler_Expression_Node_Constant(TRUE);
        $f = new Wact_Template_Compiler_Expression_Node_Constant(FALSE);
        $node = new Wact_Template_Compiler_Expression_Node_Or($t, $f);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), TRUE);
    }

}

class Wact_Template_Compiler_Expression_Node_NotTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $f = new Wact_Template_Compiler_Expression_Node_Constant(FALSE);
        $node = new Wact_Template_Compiler_Expression_Node_Not($f);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), TRUE);
    }

}

class Wact_Template_Compiler_Expression_Node_EqualToTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_EqualTo($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), FALSE);
    }

}

class Wact_Template_Compiler_Expression_Node_NotEqualTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_NotEqual($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), TRUE);
    }

}


class Wact_Template_Compiler_Expression_Node_GreaterThanTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_GreaterThan($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), FALSE);
    }

}

class Wact_Template_Compiler_Expression_Node_GreaterThanEqToTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_GreaterThanEqTo($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), FALSE);
    }

}

class Wact_Template_Compiler_Expression_Node_LessThanTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_LessThan($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), TRUE);
    }

}

class Wact_Template_Compiler_Expression_Node_LessThanEqToTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_LessThanEqTo($one, $two);
        
        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), TRUE);
    }

}

?>
