<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A property representing a constant value.
*/
class Wact_Template_Compiler_Expression_Node_Constant extends Wact_Template_Compiler_Expression_Node {
    
    private $value;
    
    function __construct($value) {
        $this->value = $value;
    }

    /**
    * Does this property refer to a constant value at compile time?
    * @return Boolean
    */
    function isConstant() {
        return TRUE;
    }

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        return $this->value;
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP(var_export($this->value, TRUE));
    }
    
}

?>