<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Template_Compiler_Attribute_Compound {

    /**
    */
    public $name;

    /**
    */
    protected $fragments = array();

    /**
    */
    function __construct($name) {
        $this->name = $name;
    }

    /**
    * Add a fragment of an attribute
    * @param Attribute Attribute fragment object
    * @return void
    */
    function addAttributeFragment($fragment) {
        $this->fragments[] = $fragment;
    }

    /**
    * Can a PHP value for this reference be calculated at compile time?
    * @return Boolean
    */
    function isConstant() {
        $isConstant = TRUE;
        foreach($this->fragments as $fragment) {
            $isConstant = $isConstant && $fragment->isConstant();
        }
        return $isConstant;
    }

    /**
    * Return the value of this attribute
    * @return String
    */
    function getValue() {
        $value = "";
        foreach($this->fragments as $fragment) {
            $value .= $fragment->getValue();
        }
        return $value;
    }

    /**
    * Return the value of this attribute
    * @return String
    */
    function getValueEscaped() {
        $value = "";
        foreach($this->fragments as $fragment) {
            $value .= $fragment->getValueEscaped();
        }
        return $value;
    }

    /**
    * Generate the code
    * @param CodeWriter
    * @return void
    */
    function generate($code) {
        $code->writeHTML(' ' . $this->name);
        $code->writeHTML('="');
        foreach($this->fragments as $fragment) {
            $fragment->generate($code);
        }
        $code->writeHTML('"');
    }

    /**
    * Generate setup code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePreStatement($code) {
        foreach($this->fragments as $fragment) {
            $fragment->generatePreStatement($code);
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('(');
        $separator = '';
        foreach($this->fragments as $fragment) {
            $code->writePHP($separator);
            $fragment->generateExpression($code);
            $separator = ".";
        }
        $code->writePHP(')');
    }

    /**
    * Generate tear down code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePostStatement($code) {
        foreach($this->fragments as $fragment) {
            $fragment->generatePostStatement($code);
        }
    }

    /**
    * Prepare this attribute to be used
    * @return void
    */
    function prepare() {
        foreach($this->fragments as $fragment) {
            $fragment->prepare();
        }
    }

}

?>