<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Response_Model {

    protected $isValid = TRUE;
    protected $errorList = NULL;
    
    protected $properties;
    
    function __get($name) {
        if (isset($this->properties[$name])) {
            return $this->properties[$name];
        }
    }
    
    function __set($name, $value) {
        $this->properties[$name] = $value;
    }

    function __isset($name) {
        return array_key_exists($name, $this->properties);
    }
    
    function ensureErrorList() {
        if (!is_object($this->errorList)) {
            require_once WACT_ROOT . '/validation/errorlist.inc.php';
            $this->errorList = new ErrorList();
        }
    }

    function addError($group, $id, $fieldList = NULL, $values = NULL) {
        $this->ensureErrorList();
        $this->errorList->addError($group, $id, $fieldList, $values);
        $this->isValid = FALSE;
    }

    function addErrorMessage($message, $fieldList = NULL) {
        $this->ensureErrorList();
        $this->errorList->addErrorMessage($message, $fieldList);
        $this->isValid = FALSE;
    }
    
    function isValid() {
        return $this->isValid;
    }
    
    function getErrorList() {
        return $this->errorList;
    }
    
    function applyRule($rule) {
        $result = $rule->validate($this, $this);
        $this->isValid = $this->isValid && $result;
        return $result;
    }
        
}

?>