<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* represents parameters passed in the url, normally found in the _GET superglobal.
*/
class Wact_Request_Url extends Wact_Request_Parameter {

    function getRawValue() {
        if (isset($_GET[$this->sourceLocation])) {
            return $this->undoMagicSlashing($_GET[$this->sourceLocation]);
        }
    }

    function hasValue() {
        return array_key_exists($this->sourceLocation, $_GET);
    }

    /**
    */
    function WriteValueToTransition($transition, $value) {

        if ($this->getDefault() !== $value) {
            $transition->WriteValueToChannel(
                Wact_Controller_Transition_Link::CHANNEL_GET, 
                $this->getSourceLocation(), 
                $value);
        }

    }

}

?>