<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/*
* Represts a set of buttons as may appear on an HTML form, where the value of this
* parameter is the name of the button that was pressed, if any.
*/
class Wact_Request_PostButton extends Wact_Request_Parameter {

    /**
    * @var array a list of button names
    */
    protected $buttons;
    
    function __construct($name, $buttons) {
        $this->buttons = $buttons;
        parent::__construct($name);
    }

    function getRawValue() {
        foreach ($this->buttons as $name) {
            if (isset($_POST[$name])) {
                return $name;
            }
        }
    }

    function hasValue() {
        foreach ($this->buttons as $name) {
            if (isset($_POST[$name])) {
                return TRUE;
            }
        }
        return FALSE;
    }

}

?>