<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* represents PATH_INFO parameters.
*/
class Wact_Request_PathInfo extends Wact_Request_Parameter {

    function __construct() {
        parent::__construct('PATH_INFO');
    }

    function getRawValue() {
        if (isset($_SERVER['PATH_INFO'])) {
            return $_SERVER['PATH_INFO'];
        }
    }

    function hasValue() {
        return array_key_exists('PATH_INFO', $_SERVER);
    }

    /**
    */
    function WriteValueToTransition($transition, $value) {

        if ($this->getDefault() !== $value) {
            $transition->WriteValueToChannel(
                Wact_Controller_Transition_Link::CHANNEL_PATH_INFO, 
                $this->getSourceLocation(), 
                $value);
        }

    }

}


?>