<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 *
 *
 */
class Wact_Reflection_Object extends ReflectionObject {

    /**
     * @return Wact_Reflection_Method|null
     */
    public function getConstructor() {
        $cons = parent::getConstructor();
        if ($cons) {
            return new Wact_Reflection_Method($this->getName(), $cons->getName());
        }
        return NULL;
    }

    /**
     * @param string $name
     * @return Wact_Reflection_Method
     */
    public function getMethod($name) {
        return new Wact_Reflection_Method($this->getName(), $name);
    }

    /**
     * @return array of Wact_Reflection_Method
     */
    public function getMethods() {
        $methods = array();
        foreach (parent::getMethods() as $method) {
            $methods[] = new Wact_Reflection_Method($this->getName(), $method->getName());
        }
        return $methods;
    }

    /**
     * @param string $name
     * @return Wact_Reflection_Property
     */
    public function getProperty($name) {
        return new Wact_Reflection_Property($this->getName(), $name);
    }

    /**
     * @return array of Wact_Reflection_Property
     */
    public function getProperties() {
        $properties = array();
        foreach (parent::getProperties() as $property) {
            $properties[] = new Wact_Reflection_Property($this->getName(), $property->getName());
        }
        return $properties;
    }

    /**
     * @return Wact_Reflection_Class|false
     */
    public function getParentClass() {
        $parent = parent::getParentClass();
        if ($parent) {
            return new Wact_Reflection_Class($parent->getName());
        } else {
            return FALSE;
        }
    }

    /**
     * @return array of Wact_Reflection_Class
     */
    function getInterfaces() {
        $interfaces = array();
        foreach(parent::getInterfaces() as $name => $interface) {
            $iterfaces[$name] = new Wact_Reflection_Class($name);
        }
        return $interfaces;
    }

}

?>