<?php

class Wact_Php_Writer_PropertyTestCase extends Wact_Test_Case {
    function testName() {
        $name = 'test';
        $var = new Wact_Php_Writer_Property($name);
        $this->assertEqual($var->getName(), $name);
        $this->assertEqual($var->getDeclaration(), 'public $' . $name . ';');
    }

    function testEmptyStringValue() {
        $name = 'test';
        $var = new Wact_Php_Writer_Property($name, '');
        $this->assertEqual($var->getDeclaration(), 'public $' . $name . " = '';");
    }

    function testNonEmptyStringValue() {
        $name = 'test';
        $value = 'foo';
        $var = new Wact_Php_Writer_Property($name, $value);
        $this->assertEqual($var->getDeclaration(), 'public $' . $name . " = 'foo';");
    }

    function testNumericValue() {
        $name = 'test';
        $value = 4.55;
        $prop = new Wact_Php_Writer_Property($name, $value);
        $this->assertEqual($prop->getDeclaration(), 'public $' . $name . ' = ' . $value . ';');
    }

    function testSetVisibility() {
        $name = 'test';
        $prop = new Wact_Php_Writer_Property($name, null, 'private');
        $this->assertEqual($prop->getDeclaration(), 'private $' . $name . ';');
        $prop->setVisibility('protected');
        $this->assertEqual($prop->getDeclaration(), 'protected $' . $name . ';');
    }

    function testSetValue() {
        $name = 'test';
        $value = 4.55;
        $prop = new Wact_Php_Writer_Property($name, $value);
        $this->assertEqual($prop->getDeclaration(), 'public $' . $name . ' = ' . $value . ';');
        $value = 'foo';
        $prop->setValue($value);
        $this->assertEqual($prop->getDeclaration(), 'public $' . $name . " = 'foo';");
        $prop->setValue();
        $this->assertEqual($prop->getDeclaration(), 'public $' . $name . ';');
    }
}

?>