<?php

class Wact_Php_Writer_FunctionTestCase extends Wact_Test_Case {

    function testInstantiate() {
        $name = 'test';
        $params = '$param1, &$param2';
        $function = new Wact_Php_Writer_Function($name, $params);
        $this->assertEqual($function->getName(), $name);
        $this->assertEqual($function->getParams(), $params);
    }

    function testEmptyNoParams() {
        $function = new Wact_Php_Writer_Function('test');
        $this->assertEqual($function->getCode(), 'function test() {' . "\n\n" . '}');
    }

    function testEmptyWithParams() {
        $function = new Wact_Php_Writer_Function('test', '$param1, &$param2');
        $this->assertEqual($function->getCode(), 'function test($param1, &$param2) {' . "\n\n" . '}');
    }

    function testKeepContext() {
        $function = new Wact_Php_Writer_Function('test');
        $function->switchToHTML();
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . ' ?' . '><' . '?php ' . "\n" . '}');
    }

    function testWritePHP() {
        $st = 'echo "Hello World!"';

        $function = new Wact_Php_Writer_Function('test');
        $function->writePHP($st);
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . $st . "\n" . '}');
    }

    function testWriteHTML() {
        $st = '<p>Foo</p>';
        $st2 = '<p>Bar</p>';

        $function = new Wact_Php_Writer_Function('test');
        $function->writeHTML($st);
        $function->writeHTML($st2);
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . ' ?' . '>' . $st . $st2 . '<' . '?php ' . "\n" . '}');
    }

    function testCreateTempVariable() {
        $function = new Wact_Php_Writer_Function('test');
        $var = $function->createTempVariable();
        $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . "\n" . '}');
    }

    function testGetSecondTempVariable() {
        $function = new Wact_Php_Writer_Function('test');
        $A = $function->createTempVariable();
        $B = $function->createTempVariable();
        $this->assertNotEqual($A, $B);
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . "\n" . '}');
    }

    function testCreateTempVariables() {
        $function = new Wact_Php_Writer_Function('test');
        for ($i = 1; $i <= 30; $i++) {
            $var = $function->createTempVariable();
            $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        }
        $this->assertEqual($function->getCode(), 'function test() {' . "\n" . "\n" . '}');
    }

}

?>