<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 * This class handles uncaught exceptions, printing debugging information.
 * Use this only for debugging.
 */
class Wact_Exception_Handler {

    /**
     */
    protected $oldHandler;

    /**
     * Handle uncaught exception.
     *
     * @param Exception $e
     */
    public function handleException($e) {
        if (php_sapi_name() == 'cli') {
            echo $e;
        } else {
            $formatter = new Wact_Exception_Formatter_Html();
            $formatter->writeException($e);
            echo $formatter->getMessage();
        }
    }

    /**
     * Install an instance of this object as the exception handler.
     */
    public function install() {
        $this->oldHandler = set_exception_handler(array($this, 'handleException'));
    }

    /**
     * Remove this object as the exception hanlder and restore any old one.
     */
    public function uninstall() {
        set_exception_handler($this->oldHandler);
    }

    /**
     * Install an instance of this object as the exception handler.
     */
    static public function installNew() {
        $handler = new self();
        $handler->install();
    }

}

?>