<?php


class ParameterDispatchControllerTestCase extends Wact_Test_Case {

    protected $config;
    
    function setUp() {
        $this->config = new Wact_Config_Registry();
    }

    function getBase() {
        return $_SERVER['SCRIPT_NAME'];
    }

    function getLink($controller, $commandPath) {
        $model = new Wact_Response_Model();
        $transition = new Wact_Controller_Transition_Link($controller, $commandPath, $model);
        $transition->build();
        return  $transition->getHref();
    }

    function testSpecified() {
        $controller = new Wact_Controller_Base($this->config);

        $controller->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');

        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));

        $expectedPath = $this->getBase() . '?option=test';
        $link = $this->getLink($controller, '/test');
        $this->assertEqual($expectedPath, $link);
    }

    function testDefault() {
        $controller = new Wact_Controller_Base($this->config);

        $controller->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');

        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));

        $expectedPath = $this->getBase();
        $link = $this->getLink($controller, '/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testRoot() {
        $controller = new Wact_Controller_Base($this->config);

        $controller->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');

        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));
        
        $expectedPath = $this->getBase();
        $link = $this->getLink($controller, '/');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerSpecifiedOuterSpecified() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Url('module'))->defaultTo('index');
        $outer->addChild('index', new Wact_Controller_Base($this->config));
        $outer->addChild('test1', $inner);

        // this expectation is unneccessarily brittle due to parameter ordering.
        $expectedPath = $this->getBase() . '?option=test2&module=test1';
        $link = $this->getLink($outer, '/test1/test2');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterSpecified() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Url('module'))->defaultTo('index');
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase() . '?option=test2';
        $link = $this->getLink($outer, '/index/test2');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerSpecifiedOuterDefault() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Url('module'))->defaultTo('index');
        $outer->addChild('index', new Wact_Controller_Base($this->config));
        $outer->addChild('test1', $inner);

        $expectedPath = $this->getBase() . '?module=test1';
        $link = $this->getLink($outer, '/test1/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterDefault() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Url('module'))->defaultTo('index');
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase();
        $link = $this->getLink($outer, '/index/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterDefaultAbbreviatedCommandPath() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Url('option'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Url('module'))->defaultTo('index');
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase();
        $link = $this->getLink($outer, '/index/');
        $this->assertEqual($expectedPath, $link);
    }

}

?>