<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*The Null cache.  Always reports cache misses
*/
class Wact_Cache_Store_Null implements Wact_Cache_Store {

    /**
    * @see Wact_Cache_Store.store
    */
    public function store($key, $data, $lifetime = NULL) {
        return TRUE;
    }

    /**
    * @see Wact_Cache_Store.storeValue
    */
    public function storeValue($key, $data, $lifetime = NULL) {
        return TRUE;
    }
    
    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetch($key, $default = NULL) {
        return $default;
    }

    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetchValue($key, $default = NULL) {
        return $default;
    }
    
    /**
    * @see Wact_Cache_Store.includeCode
    */
    public function includeCode($key) {
        return FALSE;
    }
    
    /**
    * @see Wact_Cache_Store.remove
    */
    public function remove($key) {
        return TRUE;
    }
    
    /**
    * @see Wact_Cache_Store.clear
    */
    public function clear() {
        return TRUE;
    }
    
}

?>