<?php

require_once 'Wact/Loader.inc.php';
Wact_Loader::setupWact();

class WactExample {

    public $file;
    public $root;
    public $description;
    public $title;
    public $shortFile;
    public $url;

    function __construct($file, $root, $title, $description) {
        $this->file = $file;
        $this->root = $root;
        
        $this->shortFile = substr($this->file, strlen($this->root));
        $this->url = str_replace(DIRECTORY_SEPARATOR, '/', $this->shortFile);
        
        $this->title = $title;
        $this->description = $description;
    }
    
}

class WactExampleCollector {

    /**
    */
    protected $examples = array();
    protected $root;

    /**
    */
    function __construct($root) {
        $this->root = $root;
    }
    
    /**
    */
    protected function scanDirectoryForExamples($directory) {
        $dh = opendir($directory);
        if (! is_resource($dh)) {
            trigger_error("Couldn't open {$directory}", E_USER_ERROR);
        }
        while ($file = readdir($dh)) {
            if ($file == '.' || $file == '..') {
                continue;
            }
            $file_path = $directory . DIRECTORY_SEPARATOR . $file;
            if (is_dir($file_path)) {
                $this->scanDirectoryForExamples($file_path);
            } else if (strcasecmp(substr($file_path, -4, 4), '.php') == 0) {

                $text = file_get_contents($file_path);
                
                if (preg_match('/\/\*\s*^Example Name:\s*(.*)$\s*^Description:\s*(.*)$\s*\*\//m', $text, $matches)) {
                    $this->examples[] = new WactExample($file_path, $this->root, $matches[1], $matches[2]);
                }
            } 
        }
        closedir($dh);
    }

    /**
    */
    function getExamples() {
        if (empty($this->examples)) {
            $this->scanDirectoryForExamples($this->root);
        }
        return $this->examples;
    }

}

class ExampleView extends Wact_View_Partial {

    function paint() {
?>
    <li>
        <p><a href='examples<?php echo $this->myScope->model->url ?>'><?php echo $this->myScope->model->title ?></a><br />
        <small><?php echo $this->myScope->model->shortFile ?></small></p>
        <p><?php echo $this->myScope->model->description ?></p>
    </li>
<?php
    }

}

class ExamplesListView extends Wact_View_Repeated {

    function setUp() {
        $this[] = new ExampleView();
    }

    function paint() {
?>
          <ul>
<?php $this->renderChildren(); ?>
          </ul>
<?php
    }
}

class ExamplesPageView extends Wact_View_Root {

    function setUp() {
        $this['examples'] = new ExamplesListView();
    }

    function paint() {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>

    <head>
        <title>WACT Example Program Runner</title>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    </head>

    <body>

        <h1>WACT Example Program Runner</h1>

<?php $this->renderChildren(); ?>

</body>
</html>
<?php
    }
}



$collector = new WactExampleCollector(realpath('./examples'));
$examples = $collector->getExamples();

$view = new ExamplesPageView();
$view['examples']->setIterator($examples);
$view->display();

?>