<?php

/*
Example Name: Contact Form
Description: A simple form to collect and validate contact information.
*/

require_once '../../Wact/Loader.inc.php';
Wact_Loader::setupWact();

/*
We don't do any kind of validation or error reporting yet.
*/

class ContactForm extends Wact_Controller_Base {

    function setup() {
        $this->setView('layout.tpl.html');

        // Binding to the model makes it easier for us to display the values
        // from the form on the thank you page.
        // This may also may error reporting easier when we have validation
        // working.
        $this->defineInput(new Wact_Request_Post('name'))->bindToModel();
        $this->defineInput(new Wact_Request_Post('email'))->bindToModel();
        $this->defineInput(new Wact_Request_Post('message'))->bindToModel();

        // This accepts submissions where the user hits return, rather than
        // clicks on the submit button.
        $this->dispatchOn(new Wact_Request_Method());
     
        $this['GET']->setPartialView('main', '_contact.tpl.html');

        $this['POST']->setPartialView('main', '_thanks.tpl.html');
        $this['POST']->onExecuteDo($this, 'send');
    }
    
    function send($controller, $request, $response) {
        // Read parameters from either the request or the model and send the email.
        // mail("me@localhost", "Contact from " + $request->name, $request->email, $request->message);
        // This would be very insecure!
    }

}

$config = new Wact_Config_Registry();
$config->ContactForm->start();

?>