<?php

class TextAreaTestCase extends Wact_Test_Case_Web {
    
    function testExists() {
        $this->assertTrue($this->get(
            $this->getTestServerUrl('/acceptance/view/form/textarea.php')));
        $this->assertNormalPage();
    }

    function testTextAreaToUpper() {
        $this->assertTrue($this->get(
            $this->getTestServerUrl('/acceptance/view/form/textarea.php')));
        $this->assertNormalPage();
        $this->assertTitle('Case Converter');
        
        $this->assertField('text', '');
        $this->assertTrue($this->setField('text', 'This is a test!'));

        $this->assertTrue($this->clickSubmitByName('upper'));

        $this->assertNormalPage();
        $this->assertField('text', 'THIS IS A TEST!');
    }

    function testTextAreaToLower() {
        $this->assertTrue($this->get(
            $this->getTestServerUrl('/acceptance/view/form/textarea.php')));
        $this->assertNormalPage();
        $this->assertTitle('Case Converter');
        
        $this->assertField('text', '');
        $this->assertTrue($this->setField('text', 'This is a test!'));

        $this->assertTrue($this->clickSubmitByName('lower'));

        $this->assertNormalPage();
        $this->assertField('text', 'this is a test!');
    }

}

?>