<?php

require_once '../../../Wact/Loader.inc.php';
Wact_Loader::setupWact();

class MainView extends Wact_View_Root {

    function setUp() {
        $this['main'] = new ConverterFormView(array('method' => 'POST'));
    }

    function paint() {
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
    <head>
        <title>Case Converter</title>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
        <style type="text/css">
        <!--
        .Error {
            color: #FF0000;
        }
        -->
        </style>
    </head>
    <body>
        <h1 align="center">Case Converter</h1>
<?php $this->renderChildren(); ?>
    </body>
</html>
<?php
    }

}


class ConverterFormView extends Wact_View_Form {

    function setUp() {
        $this['text'] = new Wact_View_Form_TextArea(array('name' => 'text', 'rows' => 5, 'cols' => 70));
    }

    function paint() {
?>
          <table width="100%" border="0" cellspacing="2" cellpadding="3">
            <tr>
              <td width="20%"><label for="FirstName">Enter text to convert</label>
              </td>
              <td width="80%"><?php $this['text']->render(); ?>
              </td>
            </tr>
            <tr>
              <td>&nbsp;</td>
              <td><input name="upper" type="submit" id="upper" value="Convert To UPPER Case">
                <input name="lower" type="submit" id="lower" value="Convert To lower Case">
              </td>
            </tr>
          </table>
<?php
    }

}


class TextConverter extends Wact_Controller_Base {

    function setup() {
        $this->setView(new MainView());
        $this->dispatchOn(new Wact_Request_PostButton('action', array('upper', 'lower')));
        $this->defineInput(new Wact_Request_Post('text'))->bindToModel();

        $this['upper']->onExecuteDo($this, 'toUpper');
        $this['lower']->onExecuteDo($this, 'toLower');

    }

    function toLower($source, $request, $responseModel) {
        $responseModel->text = strtolower($responseModel->text);
    }

    function toUpper($source, $request, $responseModel) {
        $responseModel->text = strtoupper($responseModel->text);
    }

}

$config = new Wact_Config_Registry();
$config->TextConverter->start();

?>