<?php

class LayoutView extends Wact_View_Root {

    function setUp() {
        // maybe we should set our own id to 'main'?
        $this['main'] = new Wact_View_Partial();
    }

    function paint() {
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
    <title>Hangman</title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
</head>
<body>
<h1>WACT Hangman</h1>
<?php $this->renderChildren(); ?>
</body>
</html>
<?php
    }

}

class StartingView extends Wact_View_Partial {

    function paint() {
    $easy = new Wact_Controller_Transition_Link(
        $this->controller, '/game/play', $this->rootScope->model,
        array('level' => $this->rootScope->model->game->levels['easy']));
    $easy->build();
    $medium = new Wact_Controller_Transition_Link(
        $this->controller, '/game/play', $this->rootScope->model,
        array('level' => $this->rootScope->model->game->levels['medium']));
    $medium->build();
    $hard = new Wact_Controller_Transition_Link(
        $this->controller, '/game/play', $this->rootScope->model,
        array('level' => $this->rootScope->model->game->levels['hard']));
    $hard->build();
?>
<p>This is the game of Hangman. You must guess a word, a letter at a time.
If you make too many mistakes, you lose the game!</p>
<list>
<li><a href="<?php echo $easy->getHREF() ?>">Easy game</a>; you are allowed <?php echo $this->rootScope->model->game->levels['easy'] ?> misses.</li>
<li><a href="<?php echo $medium->getHREF() ?>">Medium game</a>; you are allowed <?php echo $this->rootScope->model->game->levels['medium'] ?> misses.</li>
<li><a href="<?php echo $hard->getHREF() ?>">Hard game</a>; you are only allowed <?php echo $this->rootScope->model->game->levels['hard'] ?> misses.</li>
</list>
<?php

    }

}

class LosingView extends Wact_View_Partial {

    function paint() {

    $again = new Wact_Controller_Transition_Link(
        $this->controller, '/', $this->rootScope->model);
    $again->build();

?>
<h2>You Lose!</h2>
<p>The word was: <?php echo $this->myScope->model->game->word ?>.</p>
<p>
<a href="<?php echo $again->getHREF() ?>">Start Again</a>
</p>
<?php
    }

}


class WinningView extends Wact_View_Partial {

    function paint() {

    $again = new Wact_Controller_Transition_Link(
        $this->controller, '/', $this->rootScope->model);
    $again->build();

?>
<h2>You Win!</h2>
<p>The word was: <?php echo $this->myScope->model->game->word ?>.</p>
<p>
<a href="<?php echo $again->getHREF() ?>">Start Again</a>
</p>
<?php
    }

}

class LetterView extends Wact_View_Partial {

    function paint() {
        $guess = new Wact_Controller_Transition_Link(
            $this->parent->parent->parent->controller, '/game/guess', $this->rootScope->model);
        $guess->build();

        if ($this->myScope->model->available) {
            ?><a href="<?php echo $guess->getHREF() ?>"><?php echo $this->myScope->model->letter ?></a> <?php
        } else {
            echo $this->myScope->model->letter, ' ';
        }
    }

}

class GameView extends Wact_View_Partial {

    function __construct() {
        $this['letterlist'] = new Wact_View_Repeated();
        $this['letterlist'][] = new LetterView();

        $this->onPreRenderDo($this, 'initializeLetterList');
    }

    function initializeLetterList($view) {
        $guesses = $this->myScope->model->game->guesses;
        $availableLetters = array();
        for ($letter=65; $letter<=90; ++$letter) {
            $availableLetters[] = array(
              'letter' => chr($letter),
              'available' => (boolean) !is_integer(strpos($guesses, chr($letter))));
        }
        $this['letterlist']->setIterator($availableLetters);
    }

    function paint() {

    $giveup = new Wact_Controller_Transition_Link(
        $this->controller, '/game/giveup', $this->rootScope->model);
    $giveup->build();

?>
<h3 style="letter-spacing: 4px;"><?php 
        $word = $this->myScope->model->game->word;
        $guesses = $this->myScope->model->game->guesses;
        for ($i = 0; $i < strlen($word); $i++) {
            if (is_integer(strpos($guesses, $word{$i}))) {
                echo $word{$i};
            } else {
                echo '_';
            }
        }
?></h3>

You have made <?php echo $this->myScope->model->game->misses ?> bad guesses out of a maximum of <?php echo $this->myScope->model->game->level ?>.

<p>Guess: 
<?php $this->renderChildren(); ?>
</p>
<p><a href="<?php echo $giveup->getHREF() ?>">Give up?</a></p>
</list>
<?php
    }

}

?>