<?php

require_once '../../Wact/Loader.inc.php';
Wact_Loader::setupWact();

class ExampleCompiler {
    protected $statusVarName = 'status';

    /**
     * @param Wact_Php_Writer $code
     */
    public function createClass($code) {
        $code->createClass('MyView', 'Wact_View_Root');
        $code->createProperty($this->statusVarName, 'Default value.<br>', 'protected');
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function writeGetStatusFunc($code) {
        $code->switchToClassScope('MyView');

        $code->createMethod('getStatus');
        $code->writePHP('return $this->' . $this->statusVarName . ';');
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function writeInitFunc($code) {
        $code->switchToClassScope('MyView');
        $code->createMethod('init');

        $var = $code->createTempVariable();
        $code->writePHP('$' . $var . ' = ');
        $code->writePHPLiteral('This is a local variable in the init function.<br>');
        $code->writePHP(';' . "\n");

        $code->writePHP('echo $' . $var . ';' . "\n");

        $code->writePHP('$this->' . $this->statusVarName . ' = ');
        $code->writePHPLiteral('Init done.<br>');
        $code->writePHP(';');
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function writeRenderFunc($code) {
        $code->switchToClassScope('MyView');
        $code->createMethod('render');

        $var = $code->createTempVariable();
        $code->writePHP('$' . $var . ' = ');
        $code->writePHPLiteral('This is a local variable in the render function.<br>');
        $code->writePHP(';' . "\n");
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function writeDisplayFunc($code) {
        $code->switchToGlobalScope();
        $code->createFunction('display');

        $var = $code->createTempVariable();
        $code->writePHP('$' . $var . ' = new MyView();' . "\n");

        $code->writePHP('$' . $var . '->init();' . "\n");

        $code->writePHP('echo $' . $var . '->getStatus();' . "\n");

        $code->writePHP('$' . $var . '->render();' . "\n");

        $code->writePHP('echo $' . $var . '->getStatus();' . "\n");
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function appendRenderFunc($code) {
        $code->switchToClassMethodScope('MyView', 'render');
        $code->writePHP('$this->' . $this->statusVarName . ' = ');
        $code->writePHPLiteral('Render done.<br>');
        $code->writePHP(';');
    }

    /**
     * @param Wact_Php_Writer $code
     */
    public function writeGlobalCode($code) {
        $code->switchToGlobalScope();
        $code->writePHP('display();');
    }

}

$code = new Wact_Php_Writer();

$compiler = new ExampleCompiler();
$compiler->createClass($code);
$compiler->writeGetStatusFunc($code);
$compiler->writeInitFunc($code);
$compiler->writeDisplayFunc($code);
$compiler->writeRenderFunc($code);
$compiler->writeGlobalCode($code);
$compiler->appendRenderFunc($code);

// file_put_contents('../../generated.php', $code->getCode());

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>

<head>
    <title>Example PHP code generated with CodeWriter</title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
</head>

<body>
<?php highlight_string($code->getCode()) ?>
</body>
</html>
