<?php

class Wact_View_ShiftToTestCase extends Wact_Test_Case {

    protected $view;

    function setUp() {
    }

    function getTree($target, $mode) {
        $shift = new Wact_View_ShiftTo($target, $mode);
        $shift->appendChild(new Wact_View_Literal('foo'));

        $target = new Wact_View_Partial();
        $target->appendChild(new Wact_View_Literal('bar'));

        $view = new Wact_View_Root();
        $view->appendChild(new Wact_View_Literal('('));
        $view->appendChild($shift);
        $view->appendChild(new Wact_View_Literal('-'));
        $view->appendChild($target, 'target');
        $view->appendChild(new Wact_View_Literal(')'));
        return $view;
    }

    function testCaptureToWithAppend() {
        $view = $this->getTree('target', Wact_View_ShiftTo::APPEND);
        $output = $view->capture();
        
        $this->assertIdentical($output, '(-barfoo)');
    }

    function testCaptureToWithPrepend() {
        $view = $this->getTree('target', Wact_View_ShiftTo::PREPEND);
        $output = $view->capture();
        
        $this->assertIdentical($output, '(-foobar)');
    }

    function testCaptureToWithReplace() {
        $view = $this->getTree('target', Wact_View_ShiftTo::REPLACE);
        $output = $view->capture();
        
        $this->assertIdentical($output, '(-foo)');
    }

    function testCaptureToWithNoTarget() {
        $view = $this->getTree('notfound', Wact_View_ShiftTo::APPEND);
        $output = $view->capture();
        
        $this->assertIdentical($output, '(-bar)');
    }

}

?>