<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Base class for View components that hold data
*/
class Wact_View_Scoped extends Wact_View_Partial {

    /**
    * An object that represents our interface to the application's
    * data model.
    * @var object
    */
    public $model;

    /**
    * @var mixed
    */
    protected $rawModel;
    
    /**
    * Registers a model object with this Wact_View_Scoped
    * @param object
    * @return void
    */
    public function setModel($model) {
        $this->rawModel = $model;
    }

    /**
    */
    protected function bindToModel($model) {
        if (is_object($model)) {
            $this->model =  $model;
        } else if (is_array($model)) {
            $this->model = new ArrayObject($model, ArrayObject::ARRAY_AS_PROPS);
        } else if (is_string($model)) {
            $path = $model;  // do we need to validate the path?
            $value = Wact_Property_Binder::getPath($this->parentScope->model, $path);
            if (is_object($value)) {
                $this->model = $value;
            } else if (is_array($value)) {
                $this->model = new ArrayObject($value, ArrayObject::ARRAY_AS_PROPS);
            } else {
                $this->model = new StdClass();
            }
        } else {
            $this->model = new StdClass();
        }
    }

    // documented in parent
    public function bindScope($root, $parentScope) {
        $this->root = $root;
        $this->rootScope = $root;
        $this->myScope = $this;
        $this->parentScope = $parentScope;

        foreach($this->children as $child) {
            $child->bindScope($root, $this);
        }
    }

    // Documented on parent
    public function render() {
        if (isset($this->preRenderListeners)) {
            $this->preRenderListeners->notify($this);
        }
        $this->bindToModel($this->rawModel);
        $this->paint();
    }
    
}

?>