<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Class that represents a repeating section in a view.
*/
class Wact_View_Repeated extends Wact_View_Scoped {

    /**
    * @var Iterator
    */
    public $iterator;

    /**
    * @var Iterator
    */
    protected $rawIterator;

    /**
    * Registers a iterator with the list component.
    * @param Iterator
    */
    public function setIterator($iterator) {
       $this->rawIterator = $iterator;
    }

    /**
    */
    protected function bindToIterator($iterator) {
        if ($iterator instanceof Iterator) {
            $this->iterator = $iterator;
        } else if (is_array($iterator)) {
            $this->iterator = new ArrayIterator($iterator);
        } else if (is_string($iterator)) {
            $path = $iterator;  // do we need to validate the path?
            $value = Wact_Property_Binder::getPath($this->parentScope->model, $path);
            if ($value instanceof Iterator) {
                $this->iterator = $value;
            } else if (is_array($value)) {
                $this->iterator = new ArrayIterator($value);
            } else {
                $this->iterator = new EmptyIterator();
            }
        } else {
            $this->iterator = new EmptyIterator();
        }
    }
   
    // documented in parent
    public function render() {
        if (isset($this->preRenderListeners)) {
            $this->preRenderListeners->notify($this);
        }
        $this->bindToIterator($this->rawIterator);
        foreach ($this->iterator as $data) {
            $this->bindToModel($data);
            $this->paint();
        }
    }
    
}

?>