<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Redirect to a specific controller
*/
class Wact_View_Redirect extends Wact_View_Root {

    /**
    * @var string
    */
    private $command;

    /**
    * @param string $command name of the controller to redirect to
    */
    public function __construct($command) {
        $this->command = $command;

        parent::__construct();
    }

    /**
    * Output the View
    */
    function render() {
        $transition = new Wact_Controller_Transition_Link(
            $this->controller, $this->command, $this->rootScope->model);

        $url = $transition->getHref();
        header('Location: ' . $url);
        ?>
        <html>
        <head>
        <meta http-equiv="refresh" content="0; url=<?php $this->url ?>">
        </head>
        </html>
        <?php
    }

}

?>
