<?php

class Wact_View_LiteralTestCase extends Wact_Test_Case {

    protected $view;
    protected $literal = 'test';

    function setUp() {
        $this->view = new Wact_View_Literal($this->literal);
    }

    function testAddChild() {
        try {
            $child = new Wact_View_Partial();
            $this->view->appendChild($child, 'child');
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_View_Exception $e) {
            $this->pass();
        }
    }
    
    function testRender() {
        ob_start();
        $this->view->render();
        $output = ob_get_contents();
        ob_end_clean();
        
        $this->assertIdentical($output, $this->literal);
    }
    
}

?>