<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A View that outputs a single PHP Value.
* This view does not accept child views.
*/
class Wact_View_Literal extends Wact_View_Partial {

    /**
    * The value to output
    */
    protected $literal;

    /**
    * @param mixed A PHP Value to output
    */
    function __construct($text) {
        $this->literal = $text;
        $this->lockChildren();
        parent::__construct();
    }
    
    // documented in parent
    function render() {
        if (isset($this->preRenderListeners)) {
            $this->preRenderListeners->notify($this);
        }
        echo $this->literal;
    }
    
}

?>