<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Deals with rendering option elements for HTML select tags
* Simple renderer for OPTIONs.  Does not support disabled
* and label attributes. Does not support OPTGROUP tags.
*/
class Wact_View_Form_Select_Option {

    /**
    * Renders an option, sending directly to display.
    * Called from WactSelectSingleComponent or WactSelectMultipleComponent
    * in their paint() method
    * @param string value to place within the option value attribute
    * @param string contents of the option tag
    * @param boolean whether the option is selected or not
    * @return void
    */
    public function renderOption($key, $contents, $selected) {
        echo '<option value="';
        echo htmlspecialchars($key, ENT_QUOTES);
        echo '"';
        if ($selected) {
            echo ' selected="selected"';
        }
        echo '>';
        if (empty($contents)) {
            echo htmlspecialchars($key, ENT_QUOTES);
        } else {
            echo htmlspecialchars($contents, ENT_QUOTES);
        }
        echo '</option>';
    }
}

?>