<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Base class for view components that represent form elements
*/
abstract class Wact_View_Form_Element extends Wact_View_Tag {
    
    protected $binding;
    protected $transitionParent;

    function __construct($tag, $attributes = array(), $binding = NULL) {
        $this->binding = $binding;
        parent::__construct($tag, $attributes);
    }

    // Documented on parent
    public function bindScope($root, $myScope) {
        parent::bindScope($root, $myScope);
        $this->transitionParent = $this->findParentByType('Wact_View_Form');
        if ($this->transitionParent === NULL) {
            throw new Wact_View_Exception(
                '"{ViewId}" must have a parent form view.',
                $this->getViewId());
        }
    }
    
}

?>