<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Represents an HTML input type="radio" tag
* Represents an HTML input type="checkbox" tag
*/
class Wact_View_Form_Checkable extends Wact_View_Form_Element {

    public function __construct($attributes = array(), $binding = NULL) {
        parent::__construct('input', $attributes, $binding);
    }
    
    /**
    * Overrides then calls with the parent render() method dealing
    * with the special case of the checked attribute
    * Called from compiled template
    * @return void
    */
    public function render() {
        $binding = $this->getAttribute('name');
        $value = $this->transitionParent->getTransition()->getPost($binding);

        // What should we do if no value attribute is specified?
        if ($value == $this->getAttribute('value')) {
            $this->setAttribute('checked', 'checked');
        } else {
            $this->removeAttribute('checked');
        }
        parent::render();
    }

}

?>