<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 * Render a callback in place
 */
class Wact_View_Callback extends Wact_View_Partial {

    /**
    * The value to output
    */
    protected $callback;

    /**
    * @param callback A callback to use to generate output
    */
    function __construct($callback) {
        $this->callback = $callback;
        $this->lockChildren();
        parent::__construct();
    }
    
    // documented in parent
    function render() {
        if (isset($this->preRenderListeners)) {
            $this->preRenderListeners->notify($this);
        }
        call_user_func($this->callback);
    }
}

?>