<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* The block tag can be used to show or hide the contents of the block.
* The BlockComponent provides an API which allows the block to be shown
* or hidden in the view.
*/
class Wact_View_Block extends Wact_View_Partial {

    /**
    * Whether the block is visible or not
    * @var boolean
    */
    public $visible = true;

    /**
    * Called within the compiled template render function to determine
    * whether block should be displayed.
    * @return boolean current state of the block
    */
    public function isVisible() {
        return $this->visible;
    }

    /**
    * Changes the block state to visible
    * @return void
    */
    public function show() {
        $this->visible = true;
    }

    /**
    * Changes the block state to invisible
    * @return void
    */
    public function hide() {
        $this->visible = false;
    }

    /**
    * Changes the block state to invisible
    * @return void
    */
    public function render() {
        if (isset($this->preRenderListeners)) {
            $this->preRenderListeners->notify($this);
        }
        if ($this->isVisible()) {
            $this->paint();
        }
    }
}

?>