<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/


/**
*/
class Wact_Tool_Web_Console extends Wact_Controller_Base {

    protected $tabs = array();

    /**
    * Get a list of all known tabs
    */
    public function getTabs() {
        $this->tabLoader->scanAll();
        return $this->tabLoader->getKnown();
    }

    /**
    * Setup this controller
    */
    function setup() {

        $this->tabLoader = new Wact_Plugin_Loader('.tab.php');
        $this->tabLoader->addPath('Wact/Tool/Web/tab', 'Wact_WebConsole_Tab');

        foreach($this->getTabs() as $tab) {
            $class = $this->tabLoader->load($tab);
            $this[$tab] = $this->config->get($class);
            $tabinfo = new StdClass();
            $tabinfo->tab = $tab;
            $tabinfo->name = $this[$tab]->getTabName();
            $this->tabs[] = $tabinfo;
        }
        $this->dispatchOn(new Wact_Request_Url('tab'))
            ->defaultTo('home')
            ->bindToModel('SelectedTab');
    
        $this->setView('Wact/Tool/Web/layout.tpl.html');
        
        // This seems like the wrong place to do this
        $this->onFocusDo($this, 'setTabsInModel');
    }
    
    /**
    */
    function setTabsInModel($sender, $request, $responseModel) {
        $responseModel->tabs = $this->tabs;
    }
    
}   

?>