<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/*
*/
class Wact_Tool_Project_Section {
    
    protected $project;
    protected $config;
    protected $defaults = array();

    function setDefaults() {
    }
    
    function bindTo($project, $config) {
        $this->config = $config;
        $this->project = $project;
        $this->setDefaults();
    }
    
    function __get($name) {
        if (method_exists($this, 'get' . $name)) {
            return $this->{'get' . $name}();
        } if (isset($this->config[$name])) {
            return $this->config[$name];
        } else if (isset($this->defaults[$name])) {
            return $this->defaults[$name];
        } else {
            throw new Exception('Configuration value is undefined');
        }
    }
    
    function __set($name, $value) {
        throw new Exception("Values are immutable.");
    }

    function __isset($name) {
        return method_exists($this, 'get' . $name) || 
            isset($this->config[$name]) || 
            isset($this->defaults[$name]);
    }

    function __unset($name) {
        throw new Exception("Values are immutable.");
    }

}
  
?>