<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A command that can be executed from the command line
*/
abstract class Wact_Tool_Cli_Command {

    /**
    * The options associated with this command
    */
    protected $options;

    /**
    * class constructor.
    */
    public function __construct() {
        $this->options = new Wact_Tool_Cli_Option_List();
    }

    /**
    * Print a generic help message for this command and its available options.
    */
    public function printUsage($project) {
        echo "There is no specific help available for this command.\n";
        $this->options->printOptions();
    }
    
    /**
    * Execute the command.
    */
    abstract function run($argv = array(), $dispatcher = NULL, $project = NULL);

}

?>