<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Test_Reporter_Cli_Quiet extends SimpleReporter {

    var $userInterface;
    var $startTime;
    var $stopTime;
    
    /**
    */
    function setInterface($ui) {
        $this->userInterface = $ui;
    }
    
    /**
    */
    function startTiming() {
        $this->startTime = microtime();
    }
    
    /**
    */
    function stopTiming() {
        $this->stopTime = microtime();
    }

    /**
    */
    function getElapsedTime() {
        return number_format(((substr($this->stopTime, 0, 9)) +
            (substr($this->stopTime,-10)) - 
            (substr($this->startTime, 0, 9)) - (substr($this->startTime, -10))), 4);
    }

    /**
    */
    function paintHeader($test_name) {
        $this->startTiming();
        parent::paintHeader($test_name);
    }

    /**
    */
    function paintFooter($test_name) {
        $this->stopTiming();
        print "Test cases run: " . $this->getTestCaseProgress() .
                "/" . $this->getTestCaseCount() .
                ", Passes: " . $this->getPassCount() .
                ", Failures: " . $this->getFailCount() .
                ", Exceptions: " . $this->getExceptionCount() . 
                ", Time: " . $this->getElapsedTime() .
                "\n";
                
    }

}

?>