<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 * Html Coverage Reporter
 */
class Wact_Test_Coverage_Reporter_Html {
    /**
     * Renders the coverage report
     * @param $report Report data
     */
    public function render($report) {
        $count = array();

        $count[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES] = 0;
        $count[Wact_Test_Coverage_Recorder::COVERED_LINES]    = 0;
        $count[Wact_Test_Coverage_Recorder::UNCOVERED_LINES]  = 0;
        $count[Wact_Test_Coverage_Recorder::DEAD_LINES]       = 0;
                
        echo '<html>';
        echo '<body>';
        echo '<table>';
        echo '<tr>';
        echo '<th>File</th>'; 
        echo '<th>Coverage</th>'; 
        echo '<th>Executable Lines</th>'; 
        echo '<th>Covered Lines</th>'; 
        echo '<th>Uncovered Lines</th>'; 
        echo '<th>Dead Lines</th>';
        echo '</tr>';
        foreach ($report as $filename => $stats) {
            echo '<tr>';

            if ($stats[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES] > 0) {
                $coverage = ($stats[Wact_Test_Coverage_Recorder::COVERED_LINES] / $stats[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES]) * 100;
            } else {
                $coverage = 0;
            }
        
            $count[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES] += $stats[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES];
            $count[Wact_Test_Coverage_Recorder::COVERED_LINES]    += $stats[Wact_Test_Coverage_Recorder::COVERED_LINES];
            $count[Wact_Test_Coverage_Recorder::UNCOVERED_LINES]  += $stats[Wact_Test_Coverage_Recorder::UNCOVERED_LINES];
            $count[Wact_Test_Coverage_Recorder::DEAD_LINES]       += $stats[Wact_Test_Coverage_Recorder::DEAD_LINES];
        
            echo '<td><a href="javascript:alert(\'/showcoverage.php?onefile=', urlencode($filename), '\')">', $filename, '</a></td>'; 
            echo '<td>', number_format($coverage, 2), '%</td>'; 
            echo '<td>', $stats[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES], '</td>'; 
            echo '<td>', $stats[Wact_Test_Coverage_Recorder::COVERED_LINES], '</td>'; 
            echo '<td>', $stats[Wact_Test_Coverage_Recorder::UNCOVERED_LINES], '</td>'; 
            echo '<td>', $stats[Wact_Test_Coverage_Recorder::DEAD_LINES], '</td>'; 
            echo '</tr>';
        }
        
        if ($count[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES] <> 0) {
            $coverage = ($count[Wact_Test_Coverage_Recorder::COVERED_LINES] / $count[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES]) * 100;
        } else {
            $coverage = 0;
        }
        echo '<tr>';
        echo '<td>Totals</td>';
        echo '<td>', number_format($coverage, 2), '%</td>'; 
        echo '<td>', $count[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES], '</td>'; 
        echo '<td>', $count[Wact_Test_Coverage_Recorder::COVERED_LINES], '</td>'; 
        echo '<td>', $count[Wact_Test_Coverage_Recorder::UNCOVERED_LINES], '</td>'; 
        echo '<td>', $count[Wact_Test_Coverage_Recorder::DEAD_LINES], '</td>'; 
        echo '</tr>';
        echo '</table>';
        
        echo '</body>';
        echo '</html>';
    }
}

?>