<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 * Xdebug-based coverage recorder class
 */
class Wact_Test_Coverage_Recorder_Xdebug extends Wact_Test_Coverage_Recorder {
    /**
     * @var string recorded coverage data for internal use
     */
    protected $coverageData;
    
    /**
     * Ensures that the requirements for this coverage recorder are currently available.  
     */
    protected function checkRequirements() {
        if (!extension_loaded('xdebug')) {
            throw new Wact_Exception_Base('This coverage recorder requires the xdebug extension to run.');
        }
    }
    
    /**
     * Starts instrumentation.
     */
    public function startInstrumentation() {
        xdebug_start_code_coverage(XDEBUG_CC_UNUSED|XDEBUG_CC_DEAD_CODE);
    }

    /**
     * Stops instrumentation and stores collected information.
     */
    public function stopInstrumentation() {
        $this->coverageData = xdebug_get_code_coverage(); 
        xdebug_stop_code_coverage();
    }

    /**
     * Processes collected coverage data and returns generated report data.
     */
    public function processCoveredFiles() {
        $report = array();
        
        foreach ($this->coverageData as $filename => $lines) {
            if (!$this->isIncluded($filename)) {
                continue;
            }
            
            if ($this->isExcludedExtension($filename)) {
                continue;
            }
            
            $counts = array_count_values($lines);
                        
            $report[$filename] = array(
                self::EXECUTABLE_LINES  => array_sum($counts),
                self::COVERED_LINES     => (isset($counts[1]) ? $counts[1] : 0),
                self::UNCOVERED_LINES   => (isset($counts[-1]) ? $counts[-1] : 0),
                self::DEAD_LINES        => (isset($counts[-2]) ? $counts[-2] : 0) 
            );
        }
        
        return $report;
    }
}

?>