<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 *    Test for a substring.
 */
class WactIsInExpectation extends SimpleExpectation {
    protected $_pattern;
    
    /**
     *    Sets the value to compare against.
     *    @param string $pattern    Pattern to search for.
     *    @param string $message    Customised message on failure.
     */
    function __construct($pattern, $message = '%s') {
        parent::__construct($message);
        $this->_pattern = (string) $pattern;
    }
    
    /**
     *    Accessor for the pattern.
     *    @return string       Perl regex as string.
     */
    function _getPattern() {
        return $this->_pattern;
    }
    
    /**
     *    Tests the expectation. True if the Perl regex
     *    matches the comparison value.
     *    @param string $compare        Comparison value.
     *    @return boolean               True if correct.
     */
    function test($compare) {
        return is_int(strpos($compare, $this->_getPattern()));
    }
    
    /**
     *    Returns a human readable test message.
     *    @param mixed $compare      Comparison value.
     *    @return string             Description of success or failure.
     */
    function testMessage($compare) {
        if ($this->test($compare)) {
            $position = strpos($compare, $this->_getPattern());
            $dumper = $this->_getDumper();
            return "String [" . $this->_getPattern() . "] detected at character [$position] in [" .
                    $dumper->describeValue($compare) . "]";
        } else {
            $dumper = $this->_getDumper();
            return "The string [" . $this->_getPattern() .
                    "] not detected in [" .
                    $dumper->describeValue($compare) . "]";
        }
    }
    
}
    

/**
* A base test case class for unit tests.
*/
abstract class Wact_Test_Case extends UnitTestCase {

    function assertIsIn($pattern, $subject, $message = "%s") {
        return $this->assert(
                new WactIsInExpectation($pattern),
                $subject,
                $message);
    }
}

?>
