<?php

class Wact_Template_Tag_wact_UnlessTestCase extends Wact_Test_Case_Template {

    protected $tmpl;
    
    function setUp() {
        parent::setUp();

        $this->tmpl = $this->createTempTemplate(
            '<wact:unless test="{$Var}">default</wact:unless>' .
            '<wact:if test="{$Var}">optional</wact:if>'
        );
    }

    function testUnlessUnset() {
        $this->expectError();
        
        $tmpl = $this->createTempTemplate('<wact:unless test="{$Var}">default</wact:unless>');
        $output = $tmpl->capture();
    }

    function testUnlessString() {
        $this->tmpl->setModel(array('Var' => 'test'));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'optional');
    }

    function testUnlessZeroString() {
        $this->tmpl->setModel(array('Var' => '0'));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');
    }

    function testUnlessEmptyString() {
        $this->tmpl->setModel(array('Var' => ''));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');
    }

    function testUnlessNumber() {
        $this->tmpl->setModel(array('Var' => 99));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'optional');
    }

    function testUnlessZero() {
        $this->tmpl->setModel(array('Var' => 0));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');
    }

    function testUnlessNull() {
        $this->tmpl->setModel(array('Var' => NULL));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');
    }

    function testUnlessTrue() {
        $this->tmpl->setModel(array('Var' => TRUE));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'optional');
    }

    function testUnlessFalse() {
        $this->tmpl->setModel(array('Var' => FALSE));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');
    }

    function testUnlessMissingFor() {
        try {
            $tmpl = $this->createTempTemplate('<wact:unless>default</wact:unless>');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Compiler_Exception_Missingattribute $e) {
            $this->pass();
            $this->assertEqual($e->getAttribute(), 'test');
        }
    }

}
?>