<?php

class Wact_Template_Tag_wact_repeatTestCase extends Wact_Test_Case_Template {

    private $fathers;
    private $numbers; 

    function setUp() {
        parent::setUp();
        
        $this->fathers =
            array(  array('First' => 'George', 'Last' => 'Washington'),
                    array('First' => 'Alexander', 'Last' => 'Hamilton'),
                    array('First' => 'Benjamin', 'Last' => 'Franklin'));
        $this->numbers = 
            array(  array('BaseNumber' => 2),
                    array('BaseNumber' => 4),
                    array('BaseNumber' => 6));
    }

    function testRepeat() {
        $t = $this->createTempTemplate(
            '<wact:repeat id="test">{$First}-</wact:repeat>');

        $t->setChildIterator('test', $this->fathers);

        $output = $t->capture();

        $this->assertEqual($output, 'George-Alexander-Benjamin-');        
    }

    function testRepeatDelimited() {
        $t = $this->createTempTemplate(
            '<wact:repeat id="test">{$First}<wact:delimiter>'."\n".'</wact:delimiter></wact:repeat>');

        $t->setChildIterator('test', $this->fathers);

        $output = $t->capture();

        $this->assertEqual($output, "George\nAlexander\nBenjamin");        
    }

    function testParity() {
        $t = $this->createTempTemplate(
            '<wact:repeat id="test">{$parity()}:{$First}'."\n".'</wact:repeat>');

        $t->setChildIterator('test', $this->fathers);

        $output = $t->capture();

        $this->assertEqual($output,"odd:George\neven:Alexander\nodd:Benjamin\n");        
    }

    function testRepeatFrom() {
        $t = $this->createTempTemplate(
            '<wact:repeat from="test">{$First}'."\n".'</wact:repeat>');

        $t->setModel(array('test' => $this->fathers));

        $output = $t->capture();

        $this->assertEqual($output, "George\nAlexander\nBenjamin\n");        
    }

    function testRepeatFromList() {
        $t = $this->createTempTemplate(
            '<wact:repeat from=\'{$[["num" => "one"], ["num" => "two"], ["num" => "three"]]}\'>{$num} </wact:repeat>');

        $output = $t->capture();

        $this->assertEqual($output, "one two three ");        
    }

    function testNestedRepeatOuterIdInnerFrom() {
        $t = $this->createTempTemplate(
            '<wact:repeat id="test">{$num}:<wact:repeat from="test">{$First} </wact:repeat></wact:repeat>');

        $t->setChildIterator('test', array(
            array('test' => $this->fathers, 'num'=>1),
            array('test' => array(), 'num'=>2),
            array('test' => $this->fathers, 'num'=>3)));

        $output = $t->capture();

        $this->assertEqual($output, "1:George Alexander Benjamin 2:3:George Alexander Benjamin ");
    }

    function testNestedRepeatOuterFromInnerFrom() {
        $t = $this->createTempTemplate(
            '<wact:repeat from="outer">{$num}:<wact:repeat from="test">{$First} </wact:repeat></wact:repeat>');

        $t->setModel(array('outer' => array(
            array('test' => $this->fathers, 'num'=>1),
            array('test' => array(), 'num'=>2),
            array('test' => $this->fathers, 'num'=>3))));

        $output = $t->capture();

        $this->assertEqual($output, "1:George Alexander Benjamin 2:3:George Alexander Benjamin ");
    }

    function testNestedRepeatOuterIdInnerId() {
        $t = $this->createTempTemplate(
            '<wact:repeat id="outer">{$BaseNumber}:<wact:repeat id="test">{$First} </wact:repeat></wact:repeat>');

        $t->setChildIterator('outer', $this->numbers);
        $t->setChildIterator('test', $this->fathers);

        $output = $t->capture();

        $this->assertEqual($output, "2:George Alexander Benjamin 4:George Alexander Benjamin 6:George Alexander Benjamin ");
    }

    function testNestedRepeatOuterFromInnerId() {
        $t = $this->createTempTemplate(
            '<wact:repeat from="test">{$BaseNumber}:<wact:repeat id="inner">{$First} </wact:repeat></wact:repeat>');

        $t->setModel(array('test' => $this->numbers));
        $t->setChildIterator('inner', $this->fathers);

        $output = $t->capture();

        $this->assertEqual($output, "2:George Alexander Benjamin 4:George Alexander Benjamin 6:George Alexander Benjamin ");
    }



}
?>