<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Present a named location where content can be inserted in the view
* @tag wact:repeat
* @end_tag ENDTAG_REQUIRED
*/
class Wact_Template_Tag_wact_repeat extends Wact_Template_Compiler_Node_View {

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Repeated';


    /**
    * Does this component desire to generate code into its own paint method?
    */
    function isPaintRequired() {
        return TRUE;
    }

    /**
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExtraMethods($code) {

        if ($this->hasAttribute('from')) {
            $oldScope = $code->switchToClassScope($this->getViewClass());
            $code->createMethod('render');

            $from = $this->getAttribute('from');

            $from->generatePreStatement($code);

            $code->writePHP('$this->setIterator(');
            $from->generateExpression($code);
            $code->writePHP(');');

            $from->generatePostStatement($code);
        
            $code->writePHP('parent::render();');    
            $code->setScope($oldScope);
        }

    }

    /**
    * Adds a child component to the array of children
    * @param object instance of a compile time component
    * @return void
    */
    function addChild($child) {
        if ($child instanceof Wact_Template_Tag_wact_delimiter) {
            $child->parent = $this;
            $child->root = $this->root;
            array_unshift($this->children, $child);
        } else {
            parent::addChild($child);
        }
    }

}
?>