<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @tag wact:prepend
* @attributes command parameters
*/
class Wact_Template_Tag_wact_prepend extends Wact_Template_Compiler_Node_View {

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_ShiftTo';

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    protected $target;

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {

        $target = $this->getAttributeValue('at');
        if (empty($target)) {
            throw new Wact_Template_Compiler_Exception_Missingattribute(
                'at', $this->tag, $this->sourceLocation->file, $this->sourceLocation->line);
        }

        $code->writePHP(var_export($target, TRUE));
        $code->writePHP(', Wact_View_ShiftTo::PREPEND');
    }

}
?>