<?php

class Wact_Template_Tag_wact_literalTestCase extends Wact_Test_Case_Template {

    function testLiteralReference() {
        $t = $this->createTempTemplate(
            '<wact:literal>{$Reference}</wact:literal>');

        $output = $t->capture();

        $this->assertEqual($output, '{$Reference}');
    }

    function testLiteralTag() {
        $t = $this->createTempTemplate(
            '<wact:literal><wact:block></wact:literal>');

        $output = $t->capture();
        
        $this->assertEqual($output, '<wact:block>');
    }

    function testLiteralNested() {
        $t = $this->createTempTemplate(
            '<wact:literal><wact:literal></wact:literal>');

        $output = $t->capture();
        
        $this->assertEqual($output, '<wact:literal>');
    }

    function testViewIdInLiteral() {
        $t = $this->createTempTemplate(
            '<wact:literal><form wact:id="*"></form></wact:literal>');

        $output = $t->capture();

        $this->assertEqual($output, '<form wact:id="*"></form>');
    }

    function testViewIdClientInLiteral () {
        $t = $this->createTempTemplate(
            '<wact:literal><form></form></wact:literal>');

        $output = $t->capture();

        $this->assertEqual($output, '<form></form>');
    }
}
?>