<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @tag wact:if
* @attributes test
*/
class Wact_Template_Tag_wact_if extends Wact_Template_Compiler_Node_Inline {

    /**
    * @param Wact_Php_Writer $code
    */
    function generatePrePaint($code) {
        if (!$this->hasAttribute('test')) {
            throw new Wact_Template_Compiler_Exception_Missingattribute(
                'test', $this->getTag(), $this->sourceLocation->file, $this->sourceLocation->line);
        }
        $test = $this->getAttribute('test');

        $test->generatePreStatement($code);

        $code->writePHP('if (');
        $test->generateExpression($code);
        $code->writePHP(') {');

        $test->generatePostStatement($code);
    }

    /**
    * @param Wact_Php_Writer $code
    */
    function generatePostPaint($code) {
        $code->writePHP('}');
    }
}
?>