<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Represents a separator that is displayed in between repeated items.
* @tag wact:delimiter
* @end_tag ENDTAG_REQUIRED
*/
class Wact_Template_Tag_wact_delimiter extends Wact_Template_Compiler_Node_View {

    /**
    * We must be an immediate child of a repeated element.
    */
    function CheckNestingLevel() {
        if ( !($this->parent instanceof Wact_Template_Tag_wact_repeat)) {
            $this->raiseCompilerError('MISSINGENCLOSURE',
                array('EnclosingTag' => 'list:LIST or ERRORSUMMARY'));
        }
    }

    /**
    * Does this component desire to generate code into its parent's paint method?
    */
    function isInlinePaintRequired() {
        return TRUE;
    }

    /**
    * @param Wact_Php_Writer $code
    */
    function generateInlineRenderCall($code) {
        $varRef = '$this->' . $code->createTempProperty();
        $code->writePHP('if (empty(' . $varRef . ')) { ');
        $code->writePHP($varRef . ' = TRUE; ');
        $code->writePHP('} else { ');
        parent::generateInlineRenderCall($code);
        $code->writePHP('}');
    }

}
?>